/*
 * Decompiled with CFR 0.152.
 */
package edu.davidson.numerics;

import edu.davidson.numerics.SDifferentiable;
import edu.davidson.numerics.SODE;

public class ModEuler
extends SODE {
    double[] dydx;
    SDifferentiable equations;
    double h = 0.01;
    int numEqu = 0;
    double tol = this.h * 1.0E-6;

    public int step(double d, double[] dArray) {
        if (dArray.length < this.numEqu) {
            this.numEqu = dArray.length;
            this.dydx = new double[this.numEqu];
            System.out.println("Warning:  Temporary arrays reset.");
        }
        int n = (int)Math.abs(d / this.h);
        for (int i = 0; i < n; ++i) {
            this.modEulerStep(this.h, dArray);
        }
        if (d - (double)n * this.h > this.tol) {
            this.modEulerStep(d - (double)n * this.h, dArray);
            ++n;
        }
        return n;
    }

    public double stepODE(double d, double[] dArray) {
        if (dArray.length < this.numEqu) {
            System.out.println("Error:  The temporary arrays are not large enough.");
            return 0.0;
        }
        this.modEulerStep(d, dArray);
        return d;
    }

    private void modEulerStep(double d, double[] dArray) {
        this.dydx = this.equations.rate(dArray);
        for (int i = 0; i < this.numEqu; ++i) {
            dArray[i] = dArray[i] + d * this.dydx[i];
            this.dydx = this.equations.rate(dArray);
        }
    }

    public void setTol(double d) {
        this.tol = d;
    }

    public double getTol() {
        return this.tol;
    }

    public void setDifferentials(SDifferentiable sDifferentiable) {
        this.equations = sDifferentiable;
        this.numEqu = this.equations.getNumEqu();
        this.dydx = new double[this.numEqu];
    }

    public double getH() {
        return this.h;
    }

    public void setH(double d) {
        this.h = d;
        this.tol = d * 1.0E-6;
    }

    public final void setNumberOfEquations(int n) {
        this.numEqu = n;
        this.dydx = new double[this.numEqu];
    }
}

