/*
 * Decompiled with CFR 0.152.
 */
package edu.davidson.graphics;

import edu.davidson.graphics.HintThread;
import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Panel;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;

public class HintPanel
extends Panel {
    String text = "";
    boolean hintVisible = false;

    public HintPanel() {
        this.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent mouseEvent) {
                HintPanel.this.hintVisible = true;
                HintPanel.this.repaint();
            }

            public void mouseExited(MouseEvent mouseEvent) {
                HintPanel.this.hintVisible = false;
                HintPanel.this.repaint();
            }
        });
    }

    public void setBubbleHelp(String string) {
        this.text = string == null ? "" : string;
        if (this.text.equals("")) {
            this.hintVisible = false;
        }
    }

    public void updateBubbleHelp(String string) {
        this.text = string == null ? "" : string;
        if (this.text.equals("")) {
            this.hintVisible = false;
            this.repaint();
        } else if (!this.hintVisible) {
            new HintThread(this);
        }
    }

    public void forceBubbleHelp(String string) {
        this.text = string == null ? "" : string;
        if (this.text.equals("")) {
            this.hintVisible = false;
        }
        this.repaint();
    }

    public void destroyHint() {
        this.hintVisible = false;
    }

    public void paintHint(Graphics graphics) {
        if (!this.hintVisible) {
            return;
        }
        graphics.setColor(Color.yellow);
        graphics.fillRect(0, this.getBounds().height - 20, this.getBounds().width - 1, 19);
        graphics.setColor(Color.black);
        graphics.drawRect(0, this.getBounds().height - 20, this.getBounds().width - 1, 19);
        FontMetrics fontMetrics = graphics.getFontMetrics();
        graphics.drawString(this.text, 2, -fontMetrics.getDescent() + this.getBounds().height - 2);
    }
}

