/*
 * Decompiled with CFR 0.152.
 */
package edu.davidson.graph;

import edu.davidson.graph.MarkerStyle;
import edu.davidson.graph.MarkerVertex;
import java.awt.Graphics;
import java.util.Vector;

public class Markers {
    public static int TYPE_DEFAULT = 0;
    public static int TYPE_CIRCLE = 1;
    public static int TYPE_SQUARE = 2;
    protected int last = 0;
    protected int max = 10;
    protected Vector[] vert = new Vector[this.max];
    protected MarkerStyle[] styles = new MarkerStyle[this.max];

    public void AddMarker(int n, int n2, int n3) {
        this.AddMarker(n, 1, new boolean[]{false}, new int[]{0}, new int[]{0});
        this.styles[n - 1].type = n3;
        this.styles[n - 1].size = n2;
    }

    public int getMarkerSize(int n) {
        return this.styles[n - 1].size;
    }

    public void AddMarker(int n, int n2, boolean[] blArray, int[] nArray, int[] nArray2) {
        if (n < 1 || n > this.max) {
            return;
        }
        if (n2 <= 0) {
            return;
        }
        this.last = --n;
        this.vert[n] = new Vector();
        for (int i = 0; i < n2; ++i) {
            MarkerVertex markerVertex = new MarkerVertex();
            markerVertex.draw = blArray[i];
            markerVertex.x = nArray[i];
            markerVertex.y = nArray2[i];
            this.vert[n].addElement(markerVertex);
        }
        this.styles[n] = new MarkerStyle();
        this.styles[n].type = 0;
    }

    public void AddMarker(int n, boolean[] blArray, int[] nArray, int[] nArray2) {
        this.AddMarker(this.last + 1, n, blArray, nArray, nArray2);
    }

    public void DeleteMarker(int n) {
        if (n < 1 || n > this.max) {
            return;
        }
        this.vert[n - 1] = null;
        this.styles[n - 1] = null;
    }

    public void ClearMarkers() {
        if (this.last == 0) {
            return;
        }
        for (int i = 0; i < this.max; ++i) {
            this.vert[i] = null;
            this.styles[i] = null;
        }
        this.last = 0;
    }

    public void drawCircle(Graphics graphics, double d, int n, int n2) {
        int n3 = (int)Math.round((double)4 * d);
        graphics.fillOval(n - n3, n2 - n3, 2 * n3 + 1, 2 * n3 + 1);
    }

    public void drawSquare(Graphics graphics, double d, int n, int n2) {
        int n3 = (int)Math.round((double)4 * d);
        graphics.fillRect(n - n3, n2 - n3, 2 * n3 + 1, 2 * n3 + 1);
    }

    public void draw(Graphics graphics, int n, double d, int n2, int n3) {
        int n4 = n2;
        int n5 = n2;
        int n6 = n3;
        int n7 = n3;
        if (n < 1 || n > this.max) {
            return;
        }
        if (d <= 0.0) {
            return;
        }
        Vector vector = this.vert[n - 1];
        if (vector == null) {
            return;
        }
        if (this.styles[n - 1].type == TYPE_CIRCLE) {
            this.drawCircle(graphics, d, n2, n3);
            return;
        }
        if (this.styles[n - 1].type == TYPE_SQUARE) {
            this.drawSquare(graphics, d, n2, n3);
            return;
        }
        for (int i = 0; i < vector.size(); ++i) {
            MarkerVertex markerVertex = (MarkerVertex)vector.elementAt(i);
            if (markerVertex.draw) {
                n5 = n2 + (int)((double)markerVertex.x * d);
                n7 = n3 + (int)((double)markerVertex.y * d);
                graphics.drawLine(n4, n6, n5, n7);
                n4 = n5;
                n6 = n7;
                continue;
            }
            n4 = n2 + (int)((double)markerVertex.x * d);
            n6 = n3 + (int)((double)markerVertex.y * d);
        }
    }
}

