/*
 * Decompiled with CFR 0.152.
 */
package edu.davidson.display;

import edu.davidson.display.Constraint;
import edu.davidson.display.SScalable;
import edu.davidson.display.Thing;
import edu.davidson.tools.SApplet;
import java.awt.Graphics;

public class ConstraintEllipse
extends Constraint {
    public ConstraintEllipse(SApplet sApplet, SScalable sScalable, double d, double d2, double d3, double d4) {
        super(sApplet, sScalable, d, d2, d3, d4);
    }

    public void paint(Graphics graphics) {
        if (!this.visible) {
            return;
        }
        int n = this.canvas.pixFromX(this.left);
        int n2 = this.canvas.pixFromY(this.top);
        this.w = this.canvas.pixFromX(this.right) - n;
        this.h = this.canvas.pixFromY(this.bottom) - n2;
        graphics.setColor(this.color);
        if (this.w > 0 && this.h > 0) {
            graphics.drawOval(n, n2, this.w, this.h);
        } else if (this.w > 0 && this.h == 0) {
            graphics.drawLine(n, n2, n + this.w, n2);
        } else if (this.w == 0 && this.h > 0) {
            graphics.drawLine(n, n2, n, n2 + this.h);
        }
    }

    public void enforceConstraint(Thing thing) {
        double d = thing.x;
        double d2 = thing.y;
        double d3 = Math.abs(this.right - this.left) / 2.0;
        double d4 = Math.abs(this.top - this.bottom) / 2.0;
        if (d3 > 0.0 && d4 > 0.0) {
            double d5 = Math.atan2(d, d2);
            double d6 = Math.cos(d5);
            double d7 = Math.sin(d5);
            double d8 = 1.0 / Math.sqrt(d6 * d6 / d3 / d3 + d7 * d7 / d4 / d4);
            thing.x = d8 * Math.sin(d5);
            thing.y = d8 * Math.cos(d5);
        } else if (d3 == 0.0 && d4 > 0.0) {
            thing.x = this.right;
        } else if (d4 == 0.0 && d3 > 0.0) {
            thing.y = this.top;
        } else {
            thing.x = this.right;
            thing.y = this.top;
        }
    }
}

